
// This class keeps track of whether or not the specific power-ups are
// active. The circumstances for which they remain active are left up to
// the caller.

 public class PowerUpManager
 {
      private double speed;
      private boolean spedUp;
      private boolean defense;
	  private boolean forceField;

      public PowerUpManager(int inSpeed)
      {
        speed = inSpeed;
        spedUp = false;
        defense = false;
        forceField = false;
      }

      //  Gives gameObject an increase in speed.

	  public void speedUpActivate(int fastSpeed)
	  {
		  System.out.println("speed up!");
		  speed = fastSpeed;
		  spedUp = true;
	  }

	  // Returns gameObject to normal speed.

	  public void speedUpDeactivate(int normalSpeed)
	  {
		  System.out.println("speed down!");
		  speed = normalSpeed;
		  spedUp = false;
	  }

	  //  Gives gameObject invincibility.

	  public void defenseActivate()
	  {
		  System.out.println("defense on!");
		  defense = true;
	  }

	  // Turns gameObject's invincibility off.

	  public void defenseDeactivate()
	  {
		  System.out.println("defense off!");
		  defense = false;
	  }

      // Gives the gameObject a force field.

	  public void forceFieldActivate()
	  {
	      System.out.println("force field!");
		  forceField = true;
	  }

	  // Turns the gameObject's force field off.

	  public void forceFieldDeactivate()
	  {
		  System.out.println("force field down!");
	      forceField = false;
	  }

      public double getSpeed()
      {
		  return speed;
	  }

      public void setSpeed(double inSpeed)
      {
		  speed = inSpeed;
	  }

      public boolean speedUpOn()
      {
		  return spedUp;
	  }

	  public boolean defenseOn()
	  {
		  return defense;
      }

	  public boolean forceFieldOn()
	  {
		  return forceField;
	  }
}
